/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.lockmgr;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HscResourceId;
import com.ibm.hsc.fsp.lockmgr.FspLockMgr;
import com.ibm.hsc.fsp.lockmgr.FspReqRecord;
import java.util.Date;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt32;

public class FspLockRequest {
    private FspLockMgr mLockMgr;
    private Vector mReqRecs;
    private String mThreadName;
    private UnsignedInt32 mLockReqId;
    private UnsignedInt32 mFspReqId = null;
    private long mTimeStamp = 0L;
    private static final int LOCK_RECORD_LEN = 16;
    private static int mLockSeq = 0;

    public static void bigEndianIntToBytes(int n, byte[] byArray, int n2) {
        byArray[n2 + 3] = (byte)(n & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 16 & 0xFF);
        byArray[n2] = (byte)(n >> 24 & 0xFF);
    }

    public FspLockRequest(FspLockMgr fspLockMgr, Vector vector) {
        this.mLockMgr = fspLockMgr;
        this.mThreadName = Thread.currentThread().getName();
        this.mReqRecs = vector;
        this.mLockReqId = null;
    }

    public UnsignedInt32 getLockRequestId() {
        return this.mLockReqId;
    }

    private int nextSeq() {
        if (++mLockSeq == -1) {
            ++mLockSeq;
        }
        return mLockSeq;
    }

    public UnsignedInt32 lock() throws PIHscServerException {
        byte[] byArray = this.buildLockRecords();
        this.mFspReqId = this.mLockMgr.getCmdHelper().setHmcLock(this.mReqRecs.size(), byArray);
        this.mLockReqId = new UnsignedInt32((long)this.nextSeq());
        this.mTimeStamp = System.currentTimeMillis();
        return this.mLockReqId;
    }

    UnsignedInt32 getFspReqId() {
        return this.mFspReqId;
    }

    private byte[] buildLockRecords() throws PIHscServerException {
        byte[] byArray = new byte[this.mReqRecs.size() * 16];
        for (int i = 0; i < this.mReqRecs.size(); ++i) {
            FspReqRecord fspReqRecord = (FspReqRecord)this.mReqRecs.elementAt(i);
            fspReqRecord.getFspReqRecord(byArray, i * 16);
        }
        return byArray;
    }

    public boolean unlock(Vector vector) throws PIHscServerException {
        int n;
        Vector<FspReqRecord> vector2 = new Vector<FspReqRecord>();
        byte[] byArray = null;
        byArray = vector == null ? new byte[this.mReqRecs.size() * 16] : new byte[vector.size() * 16];
        int n2 = 0;
        boolean bl = false;
        int n3 = this.mFspReqId.intValue();
        for (n = 0; n < this.mReqRecs.size(); n += 1) {
            FspReqRecord fspReqRecord = (FspReqRecord)this.mReqRecs.elementAt(n);
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    HscResourceId hscResourceId = (HscResourceId)vector.elementAt(i);
                    if (!fspReqRecord.containsRes(hscResourceId)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl && vector != null) continue;
            vector2.addElement(fspReqRecord);
            FspLockRequest.bigEndianIntToBytes(n3, byArray, n2 * 16);
            fspReqRecord.getFspReqRecord(byArray, n2++ * 16);
        }
        this.mLockMgr.getCmdHelper().unlockRecords(vector2.size(), byArray);
        n = 1;
        if (this.mReqRecs.size() > vector2.size()) {
            for (int i = 0; i < vector2.size(); ++i) {
                this.mReqRecs.remove(vector2.elementAt(i));
            }
            n = 0;
        }
        return n != 0;
    }

    public String toString() {
        String string = "\nmLockReqId " + this.mLockReqId + "\nmThreadName " + this.mThreadName + "\nmTimeStamp " + new Date(this.mTimeStamp) + "mReqRecs.size() " + this.mReqRecs.size();
        for (int i = 0; i < this.mReqRecs.size(); ++i) {
            string = string + "lock record[" + i + "] " + this.mReqRecs.elementAt(i) + "\n";
        }
        string = string + "\n";
        return string;
    }
}

